/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.EntityType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.entity.data.INPCAdvanced;
import noppes.npcs.api.entity.data.INPCAi;
import noppes.npcs.api.entity.data.INPCAnimation;
import noppes.npcs.api.entity.data.INPCDisplay;
import noppes.npcs.api.entity.data.INPCInventory;
import noppes.npcs.api.entity.data.INPCJob;
import noppes.npcs.api.entity.data.INPCRole;
import noppes.npcs.api.entity.data.INPCStats;
import noppes.npcs.api.handler.data.IDialog;
import noppes.npcs.api.handler.data.IFaction;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityLivingWrapper;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class NPCWrapper<T extends EntityNPCInterface>
extends EntityLivingWrapper<T>
implements ICustomNpc {
    public NPCWrapper(T npc) {
        super(npc);
    }

    @Override
    public String executeCommand(String command) {
        if (!Objects.requireNonNull(((EntityNPCInterface)this.entity).func_184102_h()).func_82356_Z()) {
            throw new CustomNPCsException("Command blocks need to be enabled to executeCommands", new Object[0]);
        }
        return NoppesUtilServer.runCommand((ICommandSender)this.entity, ((EntityNPCInterface)this.entity).func_70005_c_(), command, null);
    }

    @Override
    public INPCAdvanced getAdvanced() {
        return ((EntityNPCInterface)this.entity).advanced;
    }

    @Override
    public long getAge() {
        return ((EntityNPCInterface)this.entity).totalTicksAlive;
    }

    @Override
    public INPCAi getAi() {
        return ((EntityNPCInterface)this.entity).ais;
    }

    @Override
    public INPCAnimation getAnimations() {
        return ((EntityNPCInterface)this.entity).animation;
    }

    @Override
    public IDialog getDialog(int slot) {
        if (slot < 0 || slot >= ((EntityNPCInterface)this.entity).dialogs.length) {
            throw new CustomNPCsException("Slot needs to be between 0 and " + (((EntityNPCInterface)this.entity).dialogs.length - 1), new Object[0]);
        }
        IDialog dialog = null;
        int s = 0;
        TreeMap<Integer, Dialog> dialogs = DialogController.instance.dialogs;
        for (int dialogId : ((EntityNPCInterface)this.entity).dialogs) {
            if (s != slot) continue;
            if (!dialogs.containsKey(dialogId)) break;
            dialog = dialogs.get(dialogId);
            break;
        }
        return dialog;
    }

    @Override
    public INPCDisplay getDisplay() {
        return ((EntityNPCInterface)this.entity).display;
    }

    @Override
    public IFaction getFaction() {
        return ((EntityNPCInterface)this.entity).faction;
    }

    @Override
    public int getHomeX() {
        return ((EntityNPCInterface)this.entity).ais.startPos().func_177958_n();
    }

    @Override
    public int getHomeY() {
        return ((EntityNPCInterface)this.entity).ais.startPos().func_177956_o();
    }

    @Override
    public int getHomeZ() {
        return ((EntityNPCInterface)this.entity).ais.startPos().func_177952_p();
    }

    @Override
    public INPCInventory getInventory() {
        return ((EntityNPCInterface)this.entity).inventory;
    }

    @Override
    public INPCJob getJob() {
        return ((EntityNPCInterface)this.entity).advanced.jobInterface;
    }

    @Override
    public String getName() {
        return ((EntityNPCInterface)this.entity).display.getName();
    }

    @Override
    public int getOffsetX() {
        return (int)((EntityNPCInterface)this.entity).ais.bodyOffsetX;
    }

    @Override
    public int getOffsetY() {
        return (int)((EntityNPCInterface)this.entity).ais.bodyOffsetY;
    }

    @Override
    public int getOffsetZ() {
        return (int)((EntityNPCInterface)this.entity).ais.bodyOffsetZ;
    }

    public IEntityLivingBase getOwner() {
        EntityLivingBase owner = ((EntityNPCInterface)this.entity).getOwner();
        if (owner != null) {
            return (IEntityLivingBase)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)owner);
        }
        return null;
    }

    @Override
    public INPCRole getRole() {
        return ((EntityNPCInterface)this.entity).advanced.roleInterface;
    }

    @Override
    public INPCStats getStats() {
        return ((EntityNPCInterface)this.entity).stats;
    }

    @Override
    public ITimers getTimers() {
        return ((EntityNPCInterface)this.entity).timers;
    }

    @Override
    public int getType() {
        return EntityType.NPC.get();
    }

    public void giveItem(IPlayer player, IItemStack item) {
        ((EntityNPCInterface)this.entity).givePlayerItem((EntityPlayer)player.getMCEntity(), item.getMCItemStack());
    }

    @Override
    public void reset() {
        ((EntityNPCInterface)this.entity).reset();
    }

    @Override
    public void say(String message) {
        ((EntityNPCInterface)this.entity).saySurrounding(new Line(message));
    }

    public void sayTo(IPlayer player, String message) {
        ((EntityNPCInterface)this.entity).say((EntityPlayer)player.getMCEntity(), new Line(message));
    }

    @Override
    public void setDialog(int slot, IDialog dialog) {
        if (slot >= 0 && slot <= ((EntityNPCInterface)this.entity).dialogs.length) {
            if (dialog == null && slot < ((EntityNPCInterface)this.entity).dialogs.length) {
                int[] newIDs = new int[((EntityNPCInterface)this.entity).dialogs.length - 1];
                int j = 0;
                for (int i = 0; i < ((EntityNPCInterface)this.entity).dialogs.length; ++i) {
                    if (i == slot) continue;
                    newIDs[j] = ((EntityNPCInterface)this.entity).dialogs[i];
                    ++j;
                }
                ((EntityNPCInterface)this.entity).dialogs = newIDs;
            } else if (dialog != null) {
                if (slot == ((EntityNPCInterface)this.entity).dialogs.length) {
                    int[] newIDs = new int[((EntityNPCInterface)this.entity).dialogs.length + 1];
                    System.arraycopy(((EntityNPCInterface)this.entity).dialogs, 0, newIDs, 0, ((EntityNPCInterface)this.entity).dialogs.length);
                    ((EntityNPCInterface)this.entity).dialogs = newIDs;
                }
                ((EntityNPCInterface)this.entity).dialogs[slot] = dialog.getId();
            }
        } else {
            throw new CustomNPCsException("Slot needs to be between 0 and " + ((EntityNPCInterface)this.entity).dialogs.length, new Object[0]);
        }
    }

    @Override
    public void setFaction(int id) {
        Faction faction = FactionController.instance.getFaction(id);
        if (faction == null) {
            throw new CustomNPCsException("Unknown faction id: " + id, new Object[0]);
        }
        ((EntityNPCInterface)this.entity).setFaction(id);
    }

    @Override
    public void setHome(int x, int y, int z) {
        ((EntityNPCInterface)this.entity).ais.setStartPos(new BlockPos(x, y, z));
    }

    @Override
    public void setMaxHealth(float health) {
        if ((double)health == ((EntityNPCInterface)this.entity).stats.maxHealth) {
            return;
        }
        super.setMaxHealth(health);
        ((EntityNPCInterface)this.entity).stats.maxHealth = (int)health;
        ((EntityNPCInterface)this.entity).updateClient = true;
    }

    @Override
    public void setName(String name) {
        ((EntityNPCInterface)this.entity).display.setName(name);
    }

    @Override
    public void setOffset(int x, int y, int z) {
        ((EntityNPCInterface)this.entity).ais.bodyOffsetX = ValueUtil.correctFloat(x, 0.0f, 9.0f);
        ((EntityNPCInterface)this.entity).ais.bodyOffsetY = ValueUtil.correctFloat(y, 0.0f, 9.0f);
        ((EntityNPCInterface)this.entity).ais.bodyOffsetZ = ValueUtil.correctFloat(z, 0.0f, 9.0f);
        ((EntityNPCInterface)this.entity).updateClient = true;
    }

    @Override
    public void setRotation(float rotation) {
        super.setRotation(rotation);
        if (((EntityNPCInterface)this.entity).ais.orientation != (int)((EntityNPCInterface)this.entity).field_70177_z) {
            ((EntityNPCInterface)this.entity).ais.orientation = (int)((EntityNPCInterface)this.entity).field_70177_z;
            ((EntityNPCInterface)this.entity).updateClient = true;
        }
    }

    public IProjectile shootItem(double x, double y, double z, IItemStack item, int accuracy) {
        if (item == null) {
            throw new CustomNPCsException("No item was given", new Object[0]);
        }
        accuracy = ValueUtil.correctInt(accuracy, 1, 100);
        return (IProjectile)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)((EntityNPCInterface)this.entity).shoot(x, y, z, accuracy, item.getMCItemStack(), false));
    }

    public IProjectile shootItem(IEntityLivingBase target, IItemStack item, int accuracy) {
        if (item == null) {
            throw new CustomNPCsException("No item was given", new Object[0]);
        }
        if (target == null) {
            throw new CustomNPCsException("No target was given", new Object[0]);
        }
        accuracy = ValueUtil.correctInt(accuracy, 1, 100);
        return (IProjectile)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)((EntityNPCInterface)this.entity).shoot((EntityLivingBase)target.getMCEntity(), accuracy, item.getMCItemStack(), false));
    }

    @Override
    public void trigger(int id, Object ... arguments) {
        EventHooks.onScriptTriggerEvent(((EntityNPCInterface)this.entity).script, id, this.getWorld(), this.getPos(), this, arguments);
    }

    @Override
    public boolean typeOf(int type) {
        return type == EntityType.NPC.get() || super.typeOf(type);
    }

    @Override
    public void updateClient() {
        ((EntityNPCInterface)this.entity).updateClient();
    }
}

